import winreg
import os
import sys

def create_reg_key(key_path):
    try:
        # Create the key
        key = winreg.CreateKey(winreg.HKEY_LOCAL_MACHINE, key_path)
        winreg.CloseKey(key)
        print("Registry key created successfully.")

    except Exception as e:
        print("Error:", e)
        
def set_key_value(key_path, values):
    try:
        # Open the registry key
        key = winreg.OpenKey(winreg.HKEY_LOCAL_MACHINE, key_path, 0, winreg.KEY_WRITE)
        for name, value, value_type in values:
            winreg.SetValueEx(key, name, 0, value_type, value)
        winreg.CloseKey(key)

    except Exception as e:
        print(f"An error occurred: {e}")

def find_file(file_name, search_path='C:\\Users\\'):
    """Search for a file in the system."""
    for root, dirs, files in os.walk(search_path):
        if file_name in files:
            return os.path.join(root, file_name)
    return None

if __name__ == "__main__":
    
    file_name = 'npu_level_zero_umd.dll'
    file_path = find_file(file_name)
                                               
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{416f823f-2ce2-44b9-a1ba-7e98ba4cd4ba}"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Enabled", 0x1, winreg.REG_DWORD),
        ("(Default)", "Intel-NPU-LevelZero", winreg.REG_SZ),
        ("ResourceFileName", file_path, winreg.REG_EXPAND_SZ),
        ("ParameterFileName", file_path, winreg.REG_EXPAND_SZ),
        ("MessageFileName", file_path, winreg.REG_EXPAND_SZ)
    ])
    
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{416f823f-2ce2-44b9-a1ba-7e98ba4cd4ba}\ChannelReferences"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Count", 0x02, winreg.REG_DWORD)
    ])
    
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{416f823f-2ce2-44b9-a1ba-7e98ba4cd4ba}\ChannelReferences\0"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Flags", 0x0, winreg.REG_DWORD),
        ("Id", 0x10, winreg.REG_DWORD),
        ("(Default)", "Intel-NPU-LevelZero/Operational", winreg.REG_SZ)
    ])
    
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{416f823f-2ce2-44b9-a1ba-7e98ba4cd4ba}\ChannelReferences\1"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Flags", 0x0, winreg.REG_DWORD),
        ("Id", 0x11, winreg.REG_DWORD),
        ("(Default)", "Intel-NPU-LevelZero/Analytic", winreg.REG_SZ)
    ])
    
    file_name = 'npu_d3d12_umd.dll'
    file_path = find_file(file_name)
                                               
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{11a83531-4ac9-4142-8d35-e474b6b3c597}"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Enabled", 0x1, winreg.REG_DWORD),
        ("(Default)", "Intel-NPU-D3D12", winreg.REG_SZ),
        ("ResourceFileName", file_path, winreg.REG_EXPAND_SZ),
        ("ParameterFileName", file_path, winreg.REG_EXPAND_SZ),
        ("MessageFileName", file_path, winreg.REG_EXPAND_SZ)
    ])
    
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{11a83531-4ac9-4142-8d35-e474b6b3c597}\ChannelReferences"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Count", 0x01, winreg.REG_DWORD)
    ])
    
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{11a83531-4ac9-4142-8d35-e474b6b3c597}\ChannelReferences\0"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Flags", 0x0, winreg.REG_DWORD),
        ("Id", 0x10, winreg.REG_DWORD),
        ("(Default)", "Intel-NPU-D3D12/Operational", winreg.REG_SZ)
    ])

    file_name = 'npu_kmd.sys'
    file_path = find_file(file_name)
                                               
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{B3B1AAB1-3C04-4B6D-A069-59547BC18233}"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Enabled", 0x1, winreg.REG_DWORD),
        ("(Default)", "Intel-NPU-Kmd", winreg.REG_SZ),
        ("ResourceFileName", file_path, winreg.REG_EXPAND_SZ),
        ("ParameterFileName", file_path, winreg.REG_EXPAND_SZ),
        ("MessageFileName", file_path, winreg.REG_EXPAND_SZ)
    ])
    
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{B3B1AAB1-3C04-4B6D-A069-59547BC18233}\ChannelReferences"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Count", 0x01, winreg.REG_DWORD)
    ])
    
    key_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\WINEVT\Publishers\{B3B1AAB1-3C04-4B6D-A069-59547BC18233}\ChannelReferences\0"
    create_reg_key(key_path)
    
    set_key_value(key_path, [
        ("Flags", 0x0, winreg.REG_DWORD),
        ("Id", 0x10, winreg.REG_DWORD),
        ("(Default)", "Intel-NPU-Kmd/Operational", winreg.REG_SZ)
    ])